/*     ESPX - an ECMAScript Parser for (almost) XML, with namespaces
  Version 20020313
  See copying.txt */
Xdoc.prototype._ents="";
Xdoc.prototype._ns=null;
Xdoc.prototype._all=null;
Xdoc.prototype._id=0;
Xdoc.prototype._lastId=0;
Xdoc.prototype._lastEI=0;
Xdoc.prototype._elts=null;
Xdoc.prototype._hasXMLDecl=false;
Xdoc.prototype._setNodeName=Xdoc_setNodeName;
Xdoc.prototype._addChild=Xn_addChild;
Xdoc.prototype.index=-1;
Xdoc.prototype.nodeName="#document";
Xdoc.prototype.nodeValue=null;
Xdoc.prototype.nodeType=9;
Xdoc.prototype.parentNode=null;
Xdoc.prototype.childCount=0;
Xdoc.prototype.previousSibling=null;
Xdoc.prototype.nextSibling=null;
Xdoc.prototype.ownerDocument=null;
Xdoc.prototype.doctype=null;
Xdoc.prototype.documentElement=null;
Xdoc.prototype.factory=null;
Xdoc.prototype.namespaces=Xdoc_namespaces;
Xdoc.prototype.all=Xdoc_all;
Xdoc.prototype.createComment=Xdoc_createComment;
Xdoc.prototype.createProcessingInstruction=Xdoc_createProcessingInstruction;
Xdoc.prototype.createElement=Xdoc_createElement;
Xdoc.prototype.createTextNode=Xdoc_createTextNode;
Xdoc.prototype.createCDATASection=Xdoc_createCDATASection;
Xdoc.prototype.getElementsByTagName=Xdoc_getElementsByTagName;
Xdoc.prototype.getFirstChildNamed=Xcont_getFirstChildNamed;
Xdoc.prototype.uniqueID=Xn_uniqueID;
Xdoc.prototype.isLast=Xdoc_isLast;
Xdoc.prototype.xmlText=Xn_xmlText;
Xelt.prototype._ns=null;
Xelt.prototype._nsi=0;
Xelt.prototype._id=0;
Xelt.prototype._attlist="";
Xelt.prototype._xmlspace=false;
Xelt.prototype._xmllang=false;
Xelt.prototype._xmlbase=false;
Xelt.prototype._opened=false;
Xelt.prototype._closed=false;
Xelt.prototype._addChild=Xn_addChild;
Xelt.prototype.index=0;
Xelt.prototype.nodeName=null;
Xelt.prototype.nodeValue=null;
Xelt.prototype.nodeType=1;
Xelt.prototype.parentNode=null;
Xelt.prototype.childCount=0;
Xelt.prototype.previousSibling=null;
Xelt.prototype.nextSibling=null;
Xelt.prototype.ownerDocument=null;
Xelt.prototype.attributes=null;
Xelt.prototype.namespacePrefixes=Xelt_namespacePrefixes;
Xelt.prototype.namespaceURI=Xelt_namespaceURI;
Xelt.prototype.named=Xelt_named;
Xelt.prototype.getAttribute=Xelt_getAttribute;
Xelt.prototype.setAttribute=Xelt_setAttribute;
Xelt.prototype.getFirstChildNamed=Xcont_getFirstChildNamed;
Xelt.prototype.uniqueID=Xn_uniqueID;
Xelt.prototype.isLast=Xn_isLast;
Xelt.prototype.xmlText=Xn_xmlText;
Xtxt.prototype._id=0;
Xtxt.prototype.index=0;
Xtxt.prototype.nodeName="#text";
Xtxt.prototype.nodeValue=null;
Xtxt.prototype.nodeType=3;
Xtxt.prototype.parentNode=null;
Xtxt.prototype.childCount=0;
Xtxt.prototype.previousSibling=null;
Xtxt.prototype.nextSibling=null;
Xtxt.prototype.ownerDocument=null;
Xtxt.prototype.uniqueID=Xn_uniqueID;
Xtxt.prototype.isLast=Xn_isLast;
Xtxt.prototype.xmlText=Xn_xmlText;
Xcds.prototype._id=0;
Xcds.prototype.index=0;
Xcds.prototype.nodeName="#cdata-section";
Xcds.prototype.nodeValue=null;
Xcds.prototype.nodeType=4;
Xcds.prototype.parentNode=null;
Xcds.prototype.childCount=0;
Xcds.prototype.previousSibling=null;
Xcds.prototype.nextSibling=null;
Xcds.prototype.ownerDocument=null;
Xcds.prototype.uniqueID=Xn_uniqueID;
Xcds.prototype.isLast=Xn_isLast;
Xcds.prototype.xmlText=Xn_xmlText;
Xpi.prototype._id=0;
Xpi.prototype.index=0;
Xpi.prototype.nodeName=null;
Xpi.prototype.nodeValue=null;
Xpi.prototype.nodeType=7;
Xpi.prototype.parentNode=null;
Xpi.prototype.childCount=0;
Xpi.prototype.previousSibling=null;
Xpi.prototype.nextSibling=null;
Xpi.prototype.ownerDocument=null;
Xpi.prototype.uniqueID=Xn_uniqueID;
Xpi.prototype.isLast=Xn_isLast;
Xpi.prototype.xmlText=Xn_xmlText;
Xco.prototype._id=0;
Xco.prototype.index=0;
Xco.prototype.nodeName="#comment";
Xco.prototype.nodeValue=null;
Xco.prototype.nodeType=8;
Xco.prototype.parentNode=null;
Xco.prototype.childCount=0;
Xco.prototype.previousSibling=null;
Xco.prototype.nextSibling=null;
Xco.prototype.ownerDocument=null;
Xco.prototype.uniqueID=Xn_uniqueID;
Xco.prototype.isLast=Xn_isLast;
Xco.prototype.xmlText=Xn_xmlText;
XdocFactory.prototype.parser=null;
XdocFactory.prototype.hasFeature=XdocFactory_hasFeature;
XdocFactory.prototype.createDocument=XdocFactory_createDocument;
XMLParser.prototype._factory=null;
XMLParser.prototype._input=null;
XMLParser.prototype._pos=0;
XMLParser.prototype._end=0;
XMLParser.prototype._line=1;
XMLParser.prototype._column=1;
XMLParser.prototype._tos=-1;
XMLParser.prototype._last=null;
XMLParser.prototype._seenXMLDecl=false;
XMLParser.prototype._push=Xp_stack_push;
XMLParser.prototype._pop=Xp_stack_pop;
XMLParser.prototype._init=Xp_init;
XMLParser.prototype._lookForInvalidCharacters = Xp_lookForInvalidCharacters;
XMLParser.prototype._doParse=Xp_doParse;
XMLParser.prototype._shiftTo=Xp_shiftTo;
XMLParser.prototype._prepareDoc=Xp_prepareDoc;
XMLParser.prototype._eof=Xp_eof;
XMLParser.prototype._skipBlanks=Xp_skipBlanks;
XMLParser.prototype._hasNonWhiteSpace=Xp_hasNonWhiteSpace;
XMLParser.prototype._isXMLDecl=Xp_isXMLDecl;
XMLParser.prototype._isComment=Xp_isComment;
XMLParser.prototype._isPI=Xp_isPI;
XMLParser.prototype._isDocTypeDecl=Xp_isDocTypeDecl;
XMLParser.prototype._isCDATASection=Xp_isCDATASection;
XMLParser.prototype._isNamePos=Xp_isNamePos;
XMLParser.prototype._parseProlog=Xp_parseProlog;
XMLParser.prototype._parseXMLDecl=Xp_parseXMLDecl;
XMLParser.prototype._parseMisc=Xp_parseMisc;
XMLParser.prototype._parseDocTypeDecl=Xp_parseDocTypeDecl;
XMLParser.prototype._parseComment=Xp_parseComment;
XMLParser.prototype._parsePI=Xp_parsePI;
XMLParser.prototype._parseRoot=Xp_parseRoot;
XMLParser.prototype._parseElement=Xp_parseElement;
XMLParser.prototype._parseAttr=Xp_parseAttr;
XMLParser.prototype._nsHandling=Xp_nsHandling;
XMLParser.prototype._nsDeclaration=Xp_nsDeclaration;
XMLParser.prototype._nsScoping=Xp_nsScoping;
XMLParser.prototype._nsValidation=Xp_nsValidation;
XMLParser.prototype._parseText=Xp_parseText;
XMLParser.prototype._parseCDATASection=Xp_parseCDATASection;
XMLParser.prototype._messages=null;
XMLParser.prototype._raiseError=Xp_raiseError;
XMLParser.prototype.namespaceAware=true;
XMLParser.prototype.xmlLang="";
XMLParser.prototype.xmlBase="";
XMLParser.prototype.document=null;
XMLParser.prototype.documentTypeName=null;
XMLParser.prototype.parseError=null;
XMLParser.prototype.preserveWhiteSpace=false;
XMLParser.prototype.parse=Xp_parse;
XMLParser.prototype.getVersion=Xp_getVersion;
XMLParseError.prototype.parser=null;
XMLParseError.prototype.code=0;
XMLParseError.prototype.line=0;
XMLParseError.prototype.column=0;
XMLParseError.prototype.message=null;
var __espx_version_number=20020313;
var __entities={"nbsp":160,"iexcl":161,"cent":162,"pound":163,"curren":164,"yen":165,"brvbar":166,"sect":167,
"uml":168,"copy":169,"ordf":170,"laquo":171,"not":172,"shy":173,"reg":174,"macr":175,
"deg":176,"plusmn":177,"sup2":178,"sup3":179,"acute":180,"micro":181,"para":182,"middot":183,
"cedil":184,"sup1":185,"ordm":186,"raquo":187,"frac14":188,"frac12":189,"frac34":190,"iquest":191,
"Agrave":192,"Aacute":193,"Acirc":194,"Atilde":195,"Auml":196,"Aring":197,"AElig":198,"Ccedil":199,
"Egrave":200,"Eacute":201,"Ecirc":202,"Euml":203,"Igrave":204,"Iacute":205,"Icirc":206,"Iuml":207,
"ETH":208,"Ntilde":209,"Ograve":210,"Oacute":211,"Ocirc":212,"Otilde":213,"Ouml":214,"times":215,
"Oslash":216,"Ugrave":217,"Uacute":218,"Ucirc":219,"Uuml":220,"Yacute":221,"THORN":222,"szlig":223,
"agrave":224,"aacute":225,"acirc":226,"atilde":227,"auml":228,"aring":229,"aelig":230,"ccedil":231,
"egrave":232,"eacute":233,"ecirc":234,"euml":235,"igrave":236,"iacute":237,"icirc":238,"iuml":239,
"eth":240,"ntilde":241,"ograve":242,"oacute":243,"ocirc":244,"otilde":245,"ouml":246,"divide":247,
"oslash":248,"ugrave":249,"uacute":250,"ucirc":251,"uuml":252,"yacute":253,"thorn":254,"yuml":255,
"fnof":402,"bull":8226,"hellip":8230,"trade":8482,
"OElig":338,"oelig":339,"Scaron":352,"scaron":353,"Yuml":376,"circ":710,"tilde":732,"ensp":8194,
"emsp":8195,"thinsp":8201,"zwnj":8204,"zwj":8205,"lrm":8206,"rlm":8207,"ndash":8211,"mdash":8212,
"lsquo":8216,"rsquo":8217,"sbquo":8218,"ldquo":8220,"rdquo":8221,"bdquo":8222,"dagger":8224,"Dagger":8225,
"permil":8240,"lsaquo":8249,"rsaquo":8250,"euro":8364};
function Xn_addChild(node){var ns;
if(this.childCount){this[this.childCount - 1].nextSibling=node;
node.previousSibling=this[this.childCount - 1];node.index=this.childCount;}
this[this.childCount++]=node;
node.parentNode=this;
if(node.nodeType==1)
if(this.nodeType==1)for(ns in this._ns)node._ns[ns]=this._ns[ns];else
node._ns["$"]=0;}
function Xn_uniqueID(){return((this.nodeType==1)?("ESPXID_E"+this._id.toString()):("ESPXID_N"+this._id.toString()));}
function Xn_isLast(ofType){var result=true,node=this.nextSibling,t;
while(result&&node){t=node.nodeType;if(t==4)t=3;result=(t!=ofType);node=node.nextSibling;}
return result;}
function Xn_xmlText(){var result, p, a, v, i, c; var re_amp=/\&/gi; var re_lt=/\</gi; var re_quot=/\"/gi;
result=""; if(this.nodeType==1){result="<"+this.nodeName; for(p in this.attributes){
a=p.substring(1, p.length);v=this.attributes[p]; v=v.replace(re_amp, "&amp;");v=v.replace(re_lt, "&lt;");
v=v.replace(re_quot, "&quot;");
c=a.indexOf(":");if((c>0)&&(a.substring(0,c)!="xml")&&(this._ns["$"+a.substring(0,c)]==1))continue;
if((a=="xml:space")&&this._xmlspace&&((this.parentNode.nodeType==9) ||
(v!=this.parentNode.getAttribute("xml:space")))) result+=" "+a+"=\""+v+"\"";
else if((a=="xml:lang")&&this._xmllang&&((this.parentNode.nodeType==9)||(v!=this.parentNode.getAttribute("xml:lang"))))
result+=" "+a+"=\""+v+"\"";
else if((a=="xml:base")&&this._xmlbase&&((this.parentNode.nodeType==9)||(v!=this.parentNode.getAttribute("xml:base"))))
result+=" "+a+"=\""+v+"\"";
else if((a!="xml:space")&&(a!="xml:lang")&&(a!="xml:base")) result+=" "+a+"=\""+v+"\"";
}if(this.childCount){result+=">"; for(i=0; i < this.childCount; i++) result+=this[i].xmlText();
result+="</"+this.nodeName+">";}else result+="/>"; if(this.parentNode.nodeType==9) result+="\n";
}else if(this.nodeType==3) result=this.nodeValue.replace(re_amp, "&amp;").replace(re_lt, "&lt;");
else if(this.nodeType==4) result="<![CDATA["+this.nodeValue+"]]>";
else if(this.nodeType==7){result="<?"+this.nodeName+" "+this.nodeValue+"?>";
if(this.parentNode.nodeType==9) result+="\n";}else if(this.nodeType==8){
result="<!--"+this.nodeValue+"-->"; if(this.parentNode.nodeType==9) result+="\n";}
else if((this.nodeType==9)&&this.childCount){if(this._hasXMLDecl) result="<?xml version=\"1.0\"?>\n";
for(i=0; i < this.childCount; i++) result+=this[i].xmlText();}return result;}
function Xdoc(factory){this._ns=new Array();
this._all=new Object();this._elts=new Array();this.factory=factory;this._ns[0]=null;
this._ns[1]="http://www.w3.org/XML/1998/namespace";}
function Xdoc_namespaces(){return this._ns;}
function Xdoc_setNodeName(node, name){node.nodeName=name;}
function Xdoc_all(id){var result=null; if(typeof(this._all[id])!="undefined")
result=this._all[id];return result;}
function Xdoc_createComment(text){var result; result=new Xco(text);
this._lastId++;result._id=this._lastId;result.ownerDocument=this;return result;}
function Xdoc_createProcessingInstruction(target, data){
var result; result=new Xpi(data);
this._lastId++;result._id=this._lastId;result.ownerDocument=this;
this._setNodeName(result, target);return result;}
function Xdoc_createElement(tagName){var result,b4last,last;
result=new Xelt();b4last=this._lastEI++;last=this._lastEI;result._id=last;
this._elts[b4last]=result;
result.ownerDocument=this; this._setNodeName(result, tagName);
return result;}
function Xdoc_createTextNode(text){var result; result=new Xtxt(text);
this._lastId++;result._id=this._lastId;result.ownerDocument=this;return result;}
function Xdoc_createCDATASection(text){var result; result=new Xcds(text);
this._lastId++;result._id=this._lastId;result.ownerDocument=this;return result;}
function Xdoc_getElementsByTagName(tagName, ns) {
  var result = new Array(), nelt = this._elts.length, i, elt, cnt = 0;
  for(i = 0; i < nelt; i++) {
    elt = this._elts[i];
    if(elt.named(tagName, ns))
      result[cnt++] = elt;
  }
  return ( result );
}
function Xdoc_isLast(ofType){return true;}
function Xcont_getFirstChildNamed(name,ns){
var result,cnt,i,node;result=null;cnt=this.childCount;
for(i=0;i<cnt;i++){node=this[i];if(node.nodeType==1){
if(node.named(name,ns)){result=node;break;}
}else if(node.nodeName==name){result=node;break;}}
return result;}
function Xelt(){this._ns=new Object();this._ns["$xml"]=1;
this.attributes=new Object();}
function Xelt_namespacePrefixes(){var result=new Array(),ns,i=0;
for(ns in this._ns)if(ns.length>1)result[i++]=ns.substring(1,ns.length);
return result;}
function Xelt_namespaceURI(prefix) {
  var result;
  if(typeof(prefix) != "undefined")
    result = this.ownerDocument._ns[this._ns["$" + prefix]];
  else
    result = this.ownerDocument._ns[this._nsi];
  return ( result );
}
function Xelt_named(nametest, ns) {
  var name = this.nodeName, nsmark, lname;
  if(typeof(ns) == "undefined")
    return ( (name == nametest) || (nametest == "*") );
  else {
    nsmark = name.indexOf(":");
    if(nsmark > 0)
      lname = name.substring(nsmark + 1, name.length);
    else
      lname = name;
    return ( (this.namespaceURI() == ns) && ((lname == nametest) || (nametest == "*")) );
  }
}
function Xelt_getAttribute(name, ns) {
  var result, a, nsmark, aname, pre;
  result = "";
  if(typeof(ns) == "undefined") { // namespace-unaware
    if(typeof(this.attributes["@" + name]) != "undefined")
      result = this.attributes["@" + name];
  } else
    for(a in this.attributes) {
      nsmark = a.indexOf(":");
      if(nsmark > 1) {
        aname = a.substring(nsmark + 1, a.length);
        if(aname != name)
          continue;
        pre = a.substring(1, nsmark);
        if(this._ns["$" + pre] == 1) {
          result = this.attributes["@xml:" + name];
          break;
        }
        if(this.namespaceURI(pre) == ns) {
          result = this.attributes[a];
          break;
        }
      }
    }
  return ( result );
}
function Xelt_setAttribute(name, value){this.attributes["@"+name]=value;}
function Xtxt(text){this.nodeValue=text;}
function Xcds(text){this.nodeValue=text;}
function Xpi(data){this.nodeValue=data;}
function Xco(text){this.nodeValue=text;}
function XdocFactory(parser){this.parser=parser;}
function XdocFactory_hasFeature(feature, version){var result=false;
if(feature.toLowerCase()=="xml") result=(version=="1.0");
else if(feature.toLowerCase()=="espx-dom") result=(parseInt(version) <= this.parser.getVersion());
return result;}
function XdocFactory_createDocument(){return ( new Xdoc(this) );}
function XMLParser(){this._messages=new Array(
"no error","invalid XML declaration","unsupported XML version","unsupported document type declaration",
"ill-formed document","bad comment","bad processing instruction","invalid processing instruction target",
"incorrect position for XML declaration","'xml'-prefixed names are reserved","bad end tag",
"unexpected character(s)","bad start tag","duplicate attribute","missing equal sign between attribute name and value",
"bad attribute value delimiter","non-legal value for 'xml:space' attribute","no matching attribute value delimiter","bad entity reference",
"bad namespace URI for prefix","no namespace declaration in scope","bad document type declaration","invalid character(s)","bad document type name");
this._factory=new XdocFactory(this);}
function Xp_parse(xml){this._input=normalizeLineBreaks(xml);
this._doParse();this._input=null;return ( this.document );}
function Xp_getVersion(){return ( __espx_version_number );}
function Xp_stack_push(node){this._last=node; this._tos++; this[this._tos]=node;}
function Xp_stack_pop(){this[this._tos]=null; this._tos--; if(this._tos >= 0)
this._last=this[this._tos]; else this._last=null;}
function Xp_init(){this.document=null; this.documentTypeName=null; this.parseError=null; this._pos=0;
this._end=this._input.length; this._line=1; this._column=1; this._tos=-1; this._last=null;
this._seenXMLDecl=false;}
function Xp_lookForInvalidCharacters(){
var inv=this._input.search(/\x01|\x02|\x03|\x04|\x05|\x06|\x07|\x08|\x0B|\x0C|\x0E|\x0F|\x10|\x11|\x12|\x13|\x14|\x15|\x16|\x17|\x18|\x19|\x1A|\x1B|\x1C|\x1D|\x1E|\x1F/);
if(inv>=0){this._shiftTo(inv);this._raiseError(22,"","'"+this._input.charAt(this._pos)+"'");}}
function Xp_doParse(){this._init();
this._lookForInvalidCharacters();
if(this.parseError)return;
this._parseProlog();
if(!this.parseError){this._parseRoot();if(!this.parseError)
if(this.document&&this.document.documentElement &&
!this.document.documentElement._closed)
this._raiseError(4, "", "document element not closed");
if(!this.parseError) this._parseMisc(true);}
if(this.document) if(!this.parseError) this._pop();else while(this._tos >= 0) this._pop();}
function Xp_shiftTo(pos){var cpos, dest; cpos=this._pos; dest=cpos+pos;
while(cpos < dest){if(this._input.charCodeAt(cpos)==10){this._line++;
this._column=1;}else this._column++; cpos++;}
this._pos=dest;}
function Xp_prepareDoc(){this._push(this._factory.createDocument());
this.document=this._last; this.document._hasXMLDecl=this._seenXMLDecl;}
function isWhiteSpace(c){return((c=='\t')||(c=='\n')||(c=='\r')||(c==" "));}
function Xp_eof(){return ( this._pos >= this._end );}
function Xp_skipBlanks(){var end, pos, c; end=this._end; pos=this._pos;
while(pos < end){c=this._input.charAt(pos);if(isWhiteSpace(c))pos++;
else break;}this._shiftTo(pos - this._pos);}
function Xp_hasNonWhiteSpace(start, end){
var result, pos, c; result=!isWhiteSpace(this._input.charAt(start));pos=start;
while(!result&&(pos < end)){c=this._input.charAt(pos++);result=!isWhiteSpace(c);}
return result;}
function Xp_isXMLDecl(){return ( this._input.substring(this._pos, this._pos+5)=="<?xml" );}
function Xp_isComment(){return ( this._input.substring(this._pos, this._pos+4)==("<!--") );}
function Xp_isPI(){return ( this._input.substring(this._pos, this._pos+2)=="<?" );}
function Xp_isDocTypeDecl(){return ( this._input.substring(this._pos, this._pos+9)=="<!DOCTYPE" );}
function Xp_isCDATASection(){return ( this._input.substring(this._pos, this._pos+9)=="<![CDATA[" );}
function Xp_isNamePos(cpos){var result, c; result=!this._eof();if(result){
c=this._input.charAt(this._pos+cpos);result=(c=="_")||(c==":")||((c >= "A")&&(c <= "Z"))||((c >= "a")&&(c <= "z"));
if(cpos) result=result||(c==".")||(c=="-")||((c >= "0")&&(c <= "9"));}return result;}
function Xp_parseProlog(){if(this._isXMLDecl()) this._parseXMLDecl();if(!this.parseError){
this._parseMisc(false);if(!this.parseError){if(this._isDocTypeDecl()) this._parseDocTypeDecl();
if(!this.parseError) this._parseMisc(false);}}}
function Xp_parseXMLDecl(){var xmldecl_end, version_mark_end, version_mark, delim, version_end, version;
xmldecl_end=this._input.indexOf("?>", this._pos+5);
if((xmldecl_end - this._pos) < 19) this._raiseError(1, "'<?xml version=\"1.0\" ...?>'", "(eof)");
else{this._shiftTo(5);if(!isWhiteSpace(this._input.charAt(this._pos)))
this._raiseError(1, "'<?xml version=\"1.0\" ...?>'", "'<?xml"+this._input.charAt(this._pos)+" ...?>'");
else{this._skipBlanks();version_mark_end=0; while(this._isNamePos(version_mark_end))
version_mark_end++; version_mark=this._input.substring(this._pos, this._pos+version_mark_end);
if(version_mark!="version") this._raiseError(1, "'<?xml version=\"1.0\" ...?>'", "'<?xml "+this._input.substring(this._pos, this._input.indexOf("?>", this._pos))+"?>'");
else{this._shiftTo(version_mark_end);this._skipBlanks();if(this._input.charAt(this._pos)!="=")
this._raiseError(14, "", "'"+this._input.charAt(this._pos)+"'");else{
this._shiftTo(1);this._skipBlanks();delim=this._input.charAt(this._pos);
if((delim!="\"")&&(delim!="\'")) this._raiseError(15, "\" or \'", "'"+delim+"'");
else{this._shiftTo(1);version_end=this._input.indexOf(delim, this._pos) - this._pos;
if((version_end < 0)||((this._pos+version_end) > xmldecl_end)) this._raiseError(17, "'"+delim+"'", "");
else{version=this._input.substring(this._pos, this._pos+version_end);
if(version!="1.0") this._raiseError(2, "'1.0'", "'"+version+"'");
else this._shiftTo(xmldecl_end+2 - this._pos);this._seenXMLDecl=true;}}}}}}}
function Xp_parseMisc(tail){
  this._skipBlanks();
  if(!this._eof()) {
    if(tail && !this._isComment() && !this._isPI())
      this._raiseError(4, "comment or PI", "something else");
    if(!this.parseError)
    while(this._isComment() || this._isPI()) {
      if(this._isComment())
        this._parseComment();
      else
        this._parsePI();
      if(!this.parseError)
        this._skipBlanks();
      else
        break;
    }
  } else
    if(!this.document || !this.document.documentElement)
      this._raiseError(4, "document element", "(eof)");
}
function Xp_parseDocTypeDecl(){
  var _cpos, _end, _id, c;
  this._shiftTo(9);
  if(this._input.indexOf(">", this._pos) < 2)
    this._raiseError(21, "'>'", "");
  else {
    if(!isWhiteSpace(this._input.charAt(this._pos)))
      this._raiseError(21, "blank", "'"+this._input.charAt(this._pos)+"'");
    else {
      this._skipBlanks();
      _cpos = this._pos;
      if(!this._isNamePos(0))
        this._raiseError(21, "document type name", "something else");
      else {
        _end = 0;
        while(this._isNamePos(_end))
          _end++;
        _id = this._input.substring(_cpos, _cpos + _end);
        if(_id.substring(0, 3).toLowerCase() == "xml")
          this._raiseError(9, "", "'" + _id + "'");
        else {
          this._shiftTo(_end);
          this.documentTypeName = _id;
          c = this._input.charAt(this._pos);
          if((c != '>') && (c != '[') && !isWhiteSpace(c))
            this._raiseError(21, "", "'"+c+"'");
          else
            if(c != '>') {
              if(isWhiteSpace(c))
                this._skipBlanks();
              _cpos = this._pos;
              c = this._input.charAt(_cpos);
              if(c == '[')
                _end = this._input.indexOf("]>", _cpos) - _cpos + 2;
              else
                _end = this._input.indexOf(">", _cpos) - _cpos + 1;
              this._shiftTo(_end);
            } else
              this._shiftTo(1);
        }
      }
    }
  }
}
function Xp_parseComment(){var text_end, text;
text_end=this._input.indexOf("-->", this._pos+4) - this._pos;
if(text_end < 0) this._raiseError(5, "'-->'", "(eof)");
else if((this._input.indexOf("--", this._pos+4) - this._pos) < text_end)
this._raiseError(5, "", "'--' in comment");else{
text=this._input.substring(this._pos+4, this._pos+text_end);if(!this.document)
this._prepareDoc();this._last._addChild(this.document.createComment(text));
this._shiftTo(text_end+3);}}
function Xp_parsePI(){var old_pos; var bkc, target_end, target, data_end, data;
old_pos=this._pos; data_end=this._input.indexOf("?>", this._pos+2) - this._pos;
if(data_end < 3) this._raiseError(6, "'?>'", "(eof)");
else{this._shiftTo(2);if(!this._isNamePos(0)) this._raiseError(11, "'<?PIName ...?>'", "'<?"+this._input.substring(this._pos, this._pos+1)+" ...'");
else{target_end=0; while(this._isNamePos(target_end)) target_end++;
bkc=this._input.charAt(this._pos+target_end);if((bkc!="?")&&!isWhiteSpace(bkc))
this._raiseError(7, "", "'<?"+this._input.substring(this._pos, this._pos+target_end+1)+" ...'");
else{target=this._input.substring(this._pos, this._pos+target_end);
if(target.toLowerCase()=="xml") this._raiseError(8, "", "");
else{this._shiftTo(target_end);this._skipBlanks();data=this._input.substring(this._pos, old_pos+data_end);
if(!this.document) this._prepareDoc();this._last._addChild(this.document.createProcessingInstruction(target, data));
this._shiftTo(old_pos+data_end - this._pos+2);}}}}}
function endTagName(str){var lastc; lastc=str.length - 1; while((lastc > 0)&&isWhiteSpace(str.charAt(lastc)))
lastc--;return ( str.substring(0, lastc+1) );}
function Xp_parseRoot(){var etagc, str, markup;
if(!this.document) this._prepareDoc();this.document.documentElement=this._parseElement();
if(!this.parseError)if(this.documentTypeName && (this.document.documentElement.nodeName != this.documentTypeName))
this._raiseError(23, "'"+this.documentTypeName+"'", "'"+this.document.documentElement.nodeName+"'");
if(!this.parseError){while((this._tos > 0)&&!this._eof()){
if((this._last.getAttribute("xml:space")=="default")&&!this.preserveWhiteSpace){
markup=this._input.indexOf("<", this._pos);
if((markup >= 0)&&!this._hasNonWhiteSpace(this._pos, markup)){
this._skipBlanks();continue;}}
if(this._input.substring(this._pos, this._pos+2)=="</"){
etagc=this._input.indexOf(">", this._pos+2);if(etagc < (this._pos+3)){
this._raiseError(10, "'</TagName>'", "(eof)");
break;}str=this._input.substring(this._pos+2, etagc);if(endTagName(str)!=this._last.nodeName){
this._raiseError(10, "'</"+this._last.nodeName+">'", "'</"+str+">'");
break;}else{this._last._closed=true; this._pop();this._shiftTo(etagc - this._pos+1);
}}else if(!this._last._opened&&(this._input.substring(this._pos, this._pos+1)=="/")){
etagc=this._input.substring(this._pos+1, this._pos+2);
if(etagc!=">"){if(etagc!="") this._raiseError(12, "'>'", "'"+etagc+"'");
else this._raiseError(12, "'>'", "(eof)");
}else{this._last._closed=true; this._pop();this._shiftTo(2);
}}else if(this._isComment()) this._parseComment();
else if(this._isPI()) this._parsePI();else if(this._isCDATASection()) this._parseCDATASection();
else if(this._input.charAt(this._pos)=="<")
this._parseElement();else this._parseText();if(this.parseError)
break;}}}
function Xp_parseElement(){
var result, name_end, name, lastc, a_pos; result=null; if(this._input.indexOf(">", this._pos+1) < 0)
this._raiseError(12, "'>'", "(eof)");else{this._shiftTo(1);
if(!this._isNamePos(0)) this._raiseError(11, "'<TagName ...>'", "'<"+this._input.substring(this._pos, this._pos+1)+" ...'");
else{name_end=0; while(this._isNamePos(name_end)) name_end++; name=this._input.substring(this._pos, this._pos+name_end);
if((name.substring(0, 3).toLowerCase()=="xml")&&(name.indexOf(":") >= 3)) this._raiseError(9, "", "'<"+name+" ...'");
else{result=this.document.createElement(name);this._last._addChild(result);this._push(result);
if(this._last.parentNode.nodeType==9) this._last.setAttribute("xml:space", "default");
else this._last.setAttribute("xml:space", this._last.parentNode.getAttribute("xml:space"));
if(this._last.parentNode.nodeType==9) this._last.setAttribute("xml:lang", this.xmlLang);
else this._last.setAttribute("xml:lang", this._last.parentNode.getAttribute("xml:lang"));
if(this._last.parentNode.nodeType==9) this._last.setAttribute("xml:base", this.xmlBase);
else this._last.setAttribute("xml:base", this._last.parentNode.getAttribute("xml:base"));
this._shiftTo(name_end);this._skipBlanks();a_pos=this._pos;lastc=this._input.charAt(a_pos);if((lastc==">")||(lastc=="/")){
if(lastc==">"){this._shiftTo(1);this._last._opened=true;}if(this.namespaceAware)this._nsScoping(this._last);}else if(this._isNamePos(0)){
while(this._isNamePos(0)){this._parseAttr();if(this.parseError) break;}
if(!this.parseError&&!this._eof()&&this.namespaceAware){this._nsHandling(this._last);
if(!this.parseError){this._nsScoping(this._last);this._nsValidation(this._last);}}
if(!this.parseError&&!this._eof()){lastc=this._input.charAt(this._pos);if(lastc==">"){
this._shiftTo(1);this._last._opened=true;}else if(lastc!="/") this._raiseError(11, "'>' or '/>'", "'"+lastc+"'");
}}else this._raiseError(11, "'>' or '/>'", "'"+lastc+"'");}}}return result;}
function Xp_parseAttr(){var name_end, name, delim, value_end, value; name_end=0;
while(this._isNamePos(name_end)) name_end++; name=this._input.substring(this._pos, this._pos+name_end);
if((this._last._xmlspace&&(name=="xml:space"))||(this._last._xmllang&&(name=="xml:lang"))||(this._last._xmlbase&&(name=="xml:base")) ||
((name!="xml:space")&&(name!="xml:lang")&&(name!="xml:base")&&(this._last._attlist.indexOf("@"+name+"$") >= 0)))
this._raiseError(13, "", "'"+name+"'");else{
if(name.substring(0, 9).toLowerCase()=="xmlns:xml") this._raiseError(9, "", "'"+name+"'");
else{this._shiftTo(name_end);this._skipBlanks();if(this._input.charAt(this._pos)!="=")
this._raiseError(14, "", "'"+this._input.charAt(this._pos)+"'");else{
this._shiftTo(1);this._skipBlanks();delim=this._input.charAt(this._pos);
if((delim!="\"")&&(delim!="\'")) this._raiseError(15, "\" or \'", "'"+delim+"'");
else{this._shiftTo(1);value_end=this._input.indexOf(delim, this._pos) - this._pos;
if(value_end < 0) this._raiseError(17, "'"+delim+"'", "");
else{value=this._input.substring(this._pos, this._pos+value_end);
if(value.indexOf("<") >= 0) this._raiseError(11, "", "'<' in attribute value");
else{this._shiftTo(value_end+1);value = expandReferences(this.document, value);
if(value.charCodeAt(0)==0xEEEE) this._raiseError(18, "", "'"+value.substring(1, value.length)+" ...'");
else{if((name=="xml:space")&&(value!="default")&&(value!="preserve"))
this._raiseError(16, "'default' or 'preserve'", "'"+value+"'");
else{this._last.setAttribute(name, value);
this._last._xmlspace = this._last._xmlspace || (name=="xml:space");
this._last._xmllang = this._last._xmllang || (name=="xml:lang");
this._last._xmlbase = this._last._xmlbase || (name=="xml:base");
if((name!="xml:space")&&(name!="xml:lang")&&(name!="xml:base")) this._last._attlist += "@"+name+"$";
if(name=="id") this.document._all[value] = this._last; this._skipBlanks();}}}}}}}}}
function Xp_nsHandling(elt){var a,pre,ns;
for(a in elt.attributes)if(a.substring(0, 6)=="@xmlns"){
if(this.parseError)break;
if(a.length==6)pre="";else if(a.indexOf(":")>0)pre=a.substring(a.indexOf(":")+1,a.length);
else this._raiseError(9,"","'"+a.substring(1, a.length)+"'");
if(this.parseError)break;
ns=elt.attributes[a];if(ns=="")if(pre=="")elt._ns["$"]=0;
else this._raiseError(19,"","xmlns:"+pre+"=''");
else this._nsDeclaration(elt,pre,ns);}}
function Xp_nsDeclaration(elt,pre,ns){
var allns=this.document._ns,n,i=0,found=0;
n=allns.length;while((++i<n)&&!found)found=(allns[i]==ns)?i:0;
if(!found){allns[i]=ns;found=i;}elt._ns["$"+pre]=found;}
function Xp_nsScoping(elt){var pre="",nsmark=elt.nodeName.indexOf(":"),nsi;
if(nsmark>0)pre=elt.nodeName.substring(0,nsmark);nsi=elt._ns["$"+pre];
if(typeof(nsi)=="undefined")this._raiseError(20,"","namespace prefix '"+pre+"'");
else elt._nsi=nsi;}
function Xp_nsValidation(elt){var a,nam,c,pre,nsi,lnam,qna,qnas="";
for(a in elt.attributes){nam=a.substring(1,a.length);
c=nam.indexOf(":");if(c>0){pre=nam.substring(0,c);
if(pre.substring(0,5)=="xmlns")continue;nsi=elt._ns["$"+pre];
if(typeof(nsi)=="undefined")
this._raiseError(20,"","namespace prefix '"+pre+"'");
else{lnam=nam.substring(c+1,nam.length);
qna="@"+nsi+lnam+"$";
if(nsi == 1) {
  if(pre == "xml")
    continue;
  if((lnam != "space") && (lnam != "lang") && (lnam != "base")) {
    this._raiseError(9, "", "'xml:" + lnam + "'");
  } else if(lnam == "space") {
    if(!elt._xmlspace) {
      elt.attributes["@xml:space"] = elt.attributes[a];
      elt._xmlspace = true;
    } else
      this._raiseError(13, "", "'xml:space'");
  } else if(lnam == "lang") {
    if(!elt._xmllang) {
      elt.attributes["@xml:lang"] = elt.attributes[a];
      elt._xmllang = true;
    } else
      this._raiseError(13, "", "'xml:lang'");
  } else if(lnam == "base") {
    if(!elt._xmlbase) {
      elt.attributes["@xml:base"] = elt.attributes[a];
      elt._xmlbase = true;
    } else
      this._raiseError(13, "", "'xml:base'");
  }
}
else
if(qnas.indexOf(qna)>=0)this._raiseError(13,"","'"+lnam+"'");
else qnas+=qna;}}if(this.parseError)break;}}
function Xp_parseText(){
  var text_end, cds_end, text, done, last, last_sibling;
  text_end = this._input.indexOf("<", this._pos + 1) - this._pos;
  cds_end = this._input.indexOf("]]>", this._pos) - this._pos;
  if(text_end < 0)
    this._raiseError(11, "'</" + this._last.nodeName + ">'", "(eof)");
  else
    if((cds_end >= 0) && (cds_end < text_end))
      this._raiseError(4, "", "']]>'");
    else {
      text = this._input.substring(this._pos, this._pos + text_end);
      text = expandReferences(this.document, text);
      if(text.charCodeAt(0) == 0xEEEE)
        this._raiseError(18, "", "'"+text.substring(1, text.length) + " ...'");
      else {
        done = false;
        last = this._last;
        if(last.childCount) {
          last_sibling = last[last.childCount - 1];
          if((last_sibling.nodeType == 3) || (last_sibling.nodeType == 4)) {
            last_sibling.nodeValue += text;
            done = true;
          }
        }
        if(!done)
          last._addChild(this.document.createTextNode(text));
        this._shiftTo(text_end);
      }
    }
}
function Xp_parseCDATASection(){var cdata_end,cdata,done,last,last_sibling;
cdata_end=this._input.indexOf("]]>",this._pos+9)-this._pos;if(cdata_end<0)
this._raiseError(11,"']]>'","(eof)");
else if(this._input.indexOf("<",this._pos+cdata_end+3)<0)
this._raiseError(11,"'</"+this._last.nodeName+">'","(eof)");
else{cdata=this._input.substring(this._pos+9,this._pos+cdata_end);done=false;last=this._last;
if(last.childCount){last_sibling=last[last.childCount-1];
if((last_sibling.nodeType==3)||(last_sibling.nodeType==4)){last_sibling.nodeValue+=cdata;
done=true;}}if(!done)last._addChild(this.document.createCDATASection(cdata));
this._shiftTo(cdata_end + 3);}}
function Xp_raiseError(code, expected, found){this.parseError=new XMLParseError(this, code, expected, found);}
function XMLParseError(ps, ec, xp, fd){var msg; this.parser=ps; this.code=ec; this.line=this.parser._line;
this.column=this.parser._column; msg="error in line "+this.line.toString()+", column "+this.column.toString()+"\t"+this.parser._messages[ec];
if(xp!="") msg+="; expected: "+xp; if(fd!="") msg+="; found: "+fd;
this.message=msg;}
function normalizeLineBreaks(xml){var result, norm;
result=xml; norm=result.split("\r\n");result=norm.join("\n");norm=result.split("\r");
result=norm.join("\n");return result;}
function expandReferences(xdoc,xml){var result, str, iref, lhs, ref, rhs, refend;
var eerr = false; result = ""; str = xml; iref = str.indexOf("&");while((iref >= 0)&&!eerr){
lhs = str.substring(0, iref);rhs = str.substring(iref, str.length);refend = rhs.indexOf(";");
eerr = (refend < 0)||((rhs.indexOf("&", 1) > 0)&&(refend > rhs.indexOf("&", 1)));
if(!eerr){ref = rhs.substring(0, refend+1);rhs = rhs.substring(refend+1, rhs.length);
if(ref.charAt(1)=="#") result += lhs+expandCharRef(ref);else result += lhs+expandEntityRef(xdoc,ref);
str = rhs; iref = str.indexOf("&");}else{result = str.substring(iref+1, iref+51);break;}}
if(!eerr) result += str; else result = "\uEEEE&"+result;return result;}
function expandCharRef(cref){var str, result;
str=cref.substring(cref.indexOf("#")+1, cref.indexOf(";"));
if(str.charAt(0)=="x") str="0"+str; else{
while(str.charAt(0)=="0") str=str.substring(1, str.length);
}result=String.fromCharCode(str);return result;}
function expandEntityRef(xdoc,eref){var result, enam, s, n, e;
if(eref=="&amp;") result="&";else if(eref=="&apos;") result="\'";
else if(eref=="&gt;") result=">"; else if(eref=="&lt;") result="<";
else if(eref=="&quot;") result="\""; else{enam=eref.substring(1, eref.length - 1);
s=xdoc._ents.indexOf(enam+"<");
if(s>=0){n=enam.length;e=xdoc._ents.indexOf("<",s+n+1);result=xdoc._ents.substring(s+n+1,e);}
else if(typeof(__entities[enam])!="undefined") result=String.fromCharCode(__entities[enam]);
else result=eref;}
return result;}
