txsl$style = '<?xml version="1.0" encoding="iso-8859-1" ?>\
\
<txsl:transform xmlns:txsl="http://www.cjandia.com/2001/espx-tinyxsl"\
                xmlns:util="urn:this-document-utility"\
\
                xmlns="http://www.w3.org/TR/html4/"\
                xmlns:doc="http://www.cjandia.com/2001/espx-tinyxsl/doc/"\
\
                version="-0.79">\
\
<doc:menu id="menu">\
  <doc:item name="index" title="Home" />\
  <doc:item name="overview" title="Overview" />\
  <doc:item name="download" title="Download" />\
  <doc:item name="espx" title="ESPX" />\
  <doc:item name="tinyxsl" title="TinyXSL" />\
  <doc:item name="interop" title="Interoperability" />\
  <doc:item name="samples" title="Samples" />\
  <doc:item name="faq" title="FAQ" />\
  <doc:item name="support" title="Support" />\
  <doc:item name="contrib" title="Contribute" />\
  <doc:item name="license" title="License" />\
</doc:menu>\
\
<txsl:output method="xml" />\
\
<txsl:script><![CDATA[\
function util$showMenu(doc) {\
  var result = "", menu, n, i = 0, item, title, href, quot;\
  quot = String.fromCharCode(34);\
  menu = doc.all("menu");\
  n = menu.childCount;\
  if(n > 0) {\
    while(i < n) {\
      item = menu[i];\
      href = item.getAttribute("name") + ".html";\
      title = item.getAttribute("title");\
      result += "<li><a href=" + quot + href + quot + ">" + title + "</a></li>";\
      i++;\
    }\
  }\
  if(result != "")\
    result = "<ul>" + result + "</ul>";\
  this._outp.write(result);\
  return "";\
}\
function util$paraHead(elt) {\
  var n = -1;\
  while(elt) {\
    elt = elt.parentNode;\
    n++;\
  }\
  return ("h" + n.toString());\
}\
this.util$showMenu = util$showMenu;\
this.util$paraHead = util$paraHead;\
\
this.util$docns = "http://www.cjandia.com/2001/espx-tinyxsl/doc/";\
function util$hasNamedPara(node) {\
  var result = false, i = 0, n = node.childCount;\
  while(!result && (i < n)) {\
    result =\
      ((node[i].nodeType == 1) &&\
      node[i].named("p", "http://www.cjandia.com/2001/espx-tinyxsl/doc/") &&\
      (node[i].getAttribute("title") != ""));\
    i++;\
  }\
  return result;\
}\
this.util$hasNamedPara = util$hasNamedPara;\
]]></txsl:script>\
\
<txsl:template match="doc:page">\
<h1><txsl:value-of select="$(`@title`)" /></h1>\
<hr />\
<table border="0" width="100%">\
<tr>\
<td valign="top" width="200" bgcolor="lightblue">\
<txsl:value-of select="this.util$showMenu(this.document(``))" />\
<br />This page uses <a href="/2001/xdes/">XDES</a>criptions.\
</td>\
<td valign="top">\
<txsl:if test="this.util$hasNamedPara(current())">\
<b>Contents</b><ul><txsl:apply-templates select="doc:p" mode="toc" /></ul><hr />\
</txsl:if>\
<txsl:apply-templates mode="text" />\
</td>\
</tr>\
</table>\
<p><a href="http://validator.w3.org/check/referer"><img border="0" src="http://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0" height="31" width="88" /></a></p>\
</txsl:template>\
\
<txsl:template match="doc:p" mode="toc">\
<txsl:if test="$(`@title`) != ``"><li><a href="#{$(`@id`)}"><txsl:value-of select="$(`@title`)"/></a>\
<txsl:if test="this.util$hasNamedPara(current())">\
<ul><txsl:apply-templates select="doc:p" mode="toc" /></ul>\
</txsl:if>\
</li></txsl:if>\
</txsl:template>\
\
<txsl:template match="doc:p" mode="text">\
<br /><br /><txsl:if test="$(`@id`) != ``"><a id="{$(`@id`)}" name="{$(`@id`)}" /></txsl:if>\
<txsl:if test="$(`@title`) != ``"><txsl:emit txsl:element="{this.util$paraHead(current())}"><txsl:value-of select="$(`@title`)" /></txsl:emit></txsl:if>\
<txsl:apply-templates mode="text" />\
<txsl:if test="this.util$paraHead(current()) == `h2`"><hr /></txsl:if>\
</txsl:template>\
\
<txsl:template match="ul" mode="text"><ul><txsl:apply-templates/></ul></txsl:template>\
<txsl:template match="li" mode="text"><li><txsl:apply-templates/></li></txsl:template>\
<txsl:template match="a" mode="text"><a id="{$(`@id`)}" name="{$(`@name`)}" href="{$(`@href`)}"><txsl:apply-templates/></a></txsl:template>\
<txsl:template match="dl" mode="text"><dl><txsl:apply-templates/></dl></txsl:template>\
<txsl:template match="dt" mode="text"><dt><txsl:apply-templates/></dt></txsl:template>\
<txsl:template match="dd" mode="text"><dd><txsl:apply-templates/></dd></txsl:template>\
<txsl:template match="code" mode="text"><code><txsl:apply-templates/></code></txsl:template>\
<txsl:template match="pre" mode="text"><pre><txsl:apply-templates/></pre></txsl:template>\
<txsl:template match="b" mode="text"><b><txsl:apply-templates/></b></txsl:template>\
<txsl:template match="i" mode="text"><i><txsl:apply-templates/></i></txsl:template>\
<txsl:template match="u" mode="text"><u><txsl:apply-templates/></u></txsl:template>\
<txsl:template match="br" mode="text"><br /></txsl:template>\
\
</txsl:transform>';
